<?php
/* --------------------------------------------------------------
 AdminErrorServiceProvider.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Application\ErrorHandling;

use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Admin\Layout\Smarty\LayoutLoader;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Gambio\Core\Language\TextManager;
use Psr\Http\Message\ResponseFactoryInterface;
use Slim\Interfaces\CallableResolverInterface;
use Smarty;

/**
 * Class AdminErrorServiceProvider
 * @package Gambio\Admin\Application\ErrorHandling
 */
class AdminErrorServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            AdminErrorHandler::class
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(AdminErrorHandler::class)
            ->addArgument(CallableResolverInterface::class)
            ->addArgument(ResponseFactoryInterface::class)
            ->addArgument(LayoutLoader::class)
            ->addArgument(Smarty::class)
            ->addArgument(TextManager::class)
            ->addArgument(UserPreferences::class);
    }
}